#include "global.h"
#include <cmath>
#include <allegro.h>

float PI = 3.14159265f;
bool collisionMap[20][15];
float timeAdjuster = 1.0f;
float tankAdjuster = 1.0f;
int theMap[20][15];

float PlayerX = 8.0f;
float PlayerY = 8.0f;
float PlayerA = 0.0f;
float PlayerH = 100.0f;
float PlayerS = 0.0f;

float flashLevel = 0.0f;

std::list<bullet> theBullets;
std::list<bullet> enemyBullets;
std::list<explosion> theExplosions;
std::list<enemy> theEnemies;
std::list<fruit> theFruit;

float radToAng(float rad)
{
	return rad/PI * 128.0f;
}

float angToRad(float ang)
{
	return (ang/128.0f) * PI;
}

float getAngle(float x1, float y1, float x2, float y2)
{
	return radToAng(atan2(y2 - y1, x2 - x1)) + 64.0f;
} 

float getDistance(float x1, float y1, float x2, float y2)
{
	return sqrt((((x2 - x1) * (x2 - x1)) + ((y2 - y1) * (y2 - y1))));
}

float getMouseX()
{
	return (mouse_x + 16)/4.0f;
}

float getMouseY()
{
	return (mouse_y + 16)/4.0f;
}

bool checkCircles(float x1, float y1, float r1, float x2, float y2, float r2)
{
	return ((((x1 - x2) * (x1 - x2)) + ((y1 - y2) * (y1 - y2))) < ((r1 + r2) * (r1 + r2)));
}

bool checkEnemies(float x, float y, float r, enemy *me)
{
	for(std::list<enemy>::iterator i = theEnemies.begin(); i != theEnemies.end(); i++)
		if(&(*i) != me)
			if(checkCircles(x, y, r, (*i).getX(), (*i).getY(), 4.0f))
				return true;
	return false;
}

